package pypi

import (
	"a.yandex-team.ru/security/libs/go/pypi"
)

const (
	YaTeamName   = "pypi.yandex-team.ru"
	ExternalName = "pypi.org"

	YaTeamHost   = "https://pypi.yandex-team.ru"
	ExternalHost = "https://pypi.org"
)

type (
	PyPi struct {
		client pypi.Client
	}
)

func (p *PyPi) Name() string {
	return p.client.Name()
}

func (p *PyPi) Error() error {
	return p.client.Error()
}

func (p *PyPi) Next() bool {
	return p.client.Next()
}

func (p *PyPi) Package() (*Package, error) {
	pkg, err := p.client.Package()
	if err != nil {
		return nil, err
	}
	return &Package{
		Package: pkg,
	}, nil
}

func (p *PyPi) FindPackage(name string) (*Package, error) {
	pkg, err := p.client.FindPackage(name)
	if err != nil {
		return nil, err
	}
	return &Package{
		Package: pkg,
	}, nil
}
