package versionarium

import "encoding/json"

const anyRangeStr = "*"

type (
	anyRange struct{}
)

func newAnyRange() VersionRange {
	return anyRange{}
}

func (r anyRange) Type() string {
	return "any"
}

func (r anyRange) String() string {
	return anyRangeStr
}

func (r anyRange) Check(_ Version) bool {
	return true
}

func (r anyRange) MarshalJSON() ([]byte, error) {
	return json.Marshal(anyRangeStr)
}
