package versionarium

const mockType = "mock"

type (
	mockVersion struct{}
	mockRange   struct{}
)

func newMockVersion(_ string) Version {
	return &mockVersion{}
}

func newMockRange(_ string) VersionRange {
	return &mockRange{}
}

func (v mockVersion) Type() string {
	return mockType
}

func (v mockVersion) String() string {
	return ""
}

func (v mockVersion) ReleaseInfo() string {
	return ""
}

func (v mockVersion) MarshalJSON() ([]byte, error) {
	return []byte{'"', '"'}, nil
}

func (v mockVersion) BuildInfo() string {
	return ""
}

func (v mockVersion) Compare(_ Version) int {
	return 0
}

func (v mockVersion) LessThan(_ Version) bool {
	return false
}

func (v mockVersion) GreaterThan(_ Version) bool {
	return false
}

func (v mockVersion) Equal(_ Version) bool {
	return false
}

func (r mockRange) Type() string {
	return mockType
}

func (r mockRange) String() string {
	return ""
}

func (r mockRange) Check(_ Version) bool {
	return false
}
