package main

import (
	"fmt"
	"log"
	"os"
	"strings"
	"time"

	"github.com/joho/godotenv"
	"github.com/urfave/cli"
)

var version = "0.0.0" // version set at compile-time
var pluginVersion = "10"

func ver() string {
	return fmt.Sprintf("v%s (yadi v%s)", pluginVersion, version)
}

func main() {
	app := cli.NewApp()
	app.Name = "yadi plugin"
	app.Usage = "yadi plugin"
	app.Version = ver()
	app.Action = run
	app.Flags = []cli.Flag{
		cli.StringFlag{
			Name:   "token",
			Usage:  "Yadi OAuth token",
			EnvVar: "PLUGIN_TOKEN,YADI_TOKEN",
		},
		cli.StringFlag{
			Name:   "action",
			Usage:  "yadi action (test or sync)",
			EnvVar: "PLUGIN_ACTION,YADI_ACTION",
		},
		cli.StringSliceFlag{
			Name:   "actions",
			Usage:  "yadi actions (test or sync)",
			EnvVar: "PLUGIN_ACTIONS,YADI_ACTIONS",
		},
		cli.BoolTFlag{
			Name:   "auto-update",
			Usage:  "yadi auto update",
			EnvVar: "PLUGIN_AUTO_UPDATE,YADI_AUTO_UPDATE",
		},
		cli.StringFlag{
			Name:  "env-file",
			Usage: "source env file",
		},
	}

	if err := app.Run(os.Args); err != nil {
		// TODO(buglloc): WTF?!
		time.Sleep(time.Second * 1)
		log.Fatal(err)
	}

	// TODO(buglloc): WTF?!
	time.Sleep(time.Second * 1)
}

func run(c *cli.Context) error {
	fmt.Printf("Started yadi plugin version: %s\n", ver())
	if c.String("env-file") != "" {
		_ = godotenv.Load(c.String("env-file"))
	}

	commands := [][]string{}
	action := c.String("action")
	actions := c.StringSlice("actions")
	if action != "" {
		commands = append(commands, actionToCommand(action))
	} else if len(actions) != 0 {
		for _, a := range actions {
			commands = append(commands, actionToCommand(a))
		}
	}

	plugin := Plugin{
		Config: Config{
			Token:      c.String("token"),
			Commands:   commands,
			Version:    version,
			AutoUpdate: c.BoolT("auto-update"),
		},
	}

	return plugin.Exec()
}

func actionToCommand(action string) []string {
	args := strings.Split(action, " ")
	result := make([]string, 0)
	for _, a := range args {
		if a != "" {
			result = append(result, a)
		}
	}
	return result
}
