package commands

import (
	"fmt"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/library/go/core/buildinfo"
	"a.yandex-team.ru/security/yadi/snatcher/internal/config"
)

var versionCmd = &cobra.Command{
	Use:   "version",
	Short: "Show the current version",
	Run: func(cmd *cobra.Command, args []string) {
		fmt.Printf("Version: %s\n", config.FullVersion())
		fmt.Println(buildinfo.Info.ProgramVersion)
	},
}
