package config

import (
	"time"

	"a.yandex-team.ru/library/go/core/buildinfo"
	"a.yandex-team.ru/security/yadi/snatcher/internal/mailer"
)

const (
	Version = "0.6"
)

type Config struct {
	YdbDatabase  string
	YdbPath      string
	YdbEndpoint  string
	YdbAuthToken string
	DumpTimeout  time.Duration
	Mailer       *mailer.YadiMailer
}

func FullVersion() string {
	if buildinfo.Info.ArcadiaSourceRevision != "" {
		return Version + "." + buildinfo.Info.ArcadiaSourceRevision
	}
	return Version
}
