package filters

import (
	"fmt"

	"a.yandex-team.ru/security/yadi/libs/cvs"
	"a.yandex-team.ru/security/yadi/snatcher/pkg/feed"
	"a.yandex-team.ru/security/yadi/web/pkg/advisories"
)

func NewWebVuln(src feed.Vulnerability) (advisories.Advisory, error) {
	validate := func(v *advisories.Advisory) error {
		switch {
		case v.Desc == "" && len(v.ExternalReferences) == 0:
			return fmt.Errorf("description or external references cannot be empty at the same time: %+v", v)
		case v.ID == "", v.VulnerableVersions == "", v.Title == "", v.ModuleName == "", v.Desc == "", len(v.ExternalReferences) == 0, v.Severity == "":
			return fmt.Errorf("there is empty field in advisories.Advisory: %+v", v)
		default:
			return nil
		}
	}

	result := advisories.Advisory{
		ID:                 src.YadiID,
		Title:              src.Title,
		ModuleName:         src.Package,
		Desc:               src.Description,
		Lang:               src.Language,
		Severity:           cvs.ToSeverity(src.CvssScore),
		RichDescription:    src.RichDescription,
		CVSSScore:          src.CvssScore,
		VulnerableVersions: src.VulnerableVersions,
		DisclosedAtUnix:    src.DisclosedAt,
		ExternalReferences: externalReferences(src.References),
	}
	return result, validate(&result)
}

func externalReferences(src []feed.Reference) []advisories.ExternalReferences {
	dst := make([]advisories.ExternalReferences, len(src))
	for i := range src {
		dst[i] = advisories.ExternalReferences{
			Title: src[i].Title,
			URL:   src[i].URL,
		}
	}
	return dst
}
