package filters

import (
	"fmt"

	"a.yandex-team.ru/security/yadi/snatcher/pkg/feed"
	yadi "a.yandex-team.ru/security/yadi/yadi/pkg/feed"
)

const YadiVulnPrefix = "https://yadi.yandex-team.ru/vulns/vuln/%s"

func NewYadiVuln(src feed.Vulnerability) (yadi.Entry, error) {
	validate := func(v *yadi.Entry) error {
		switch {
		case v.ID == "", v.Summary == "", v.ModuleName == "", v.Reference == "", v.VulnerableVersions == "":
			return fmt.Errorf("invalid yadi Entry: %+v", v)
		default:
			return nil
		}
	}

	result := yadi.Entry{
		ID:                 src.YadiID,
		Summary:            src.Title,
		ModuleName:         src.Package,
		CVSSScore:          src.CvssScore,
		VulnerableVersions: src.VulnerableVersions,
		PatchedVersions:    src.PatchedVersions,
		PatchExists:        src.PatchExists,
		Reference:          reference(src),
	}

	return result, validate(&result)
}

func reference(vuln feed.Vulnerability) string {
	return fmt.Sprintf(YadiVulnPrefix, vuln.YadiID)
}
