package mapping

import (
	"encoding/json"
	"fmt"

	"a.yandex-team.ru/library/go/core/resource"
)

var mapping map[string]string

func init() {
	resBytes := resource.Get("/mapping/ids.json")
	if len(resBytes) == 0 {
		return
	}

	err := json.Unmarshal(resBytes, &mapping)
	if err != nil {
		panic(fmt.Sprintf("failed to unmarshal mapping resource: %s", err))
	}
}

func Replace(oldID string, fallback string) string {
	if newID, ok := mapping[oldID]; ok {
		return newID
	}
	return fallback
}
