package stat

import "sync/atomic"

type Counter struct {
	New     uint64
	Changed uint64
	Deleted uint64
}

func NewCounter() *Counter {
	return &Counter{}
}

func (c *Counter) AddNew(delta uint64) {
	atomic.AddUint64(&c.New, delta)
}

func (c *Counter) AddChanged(delta uint64) {
	atomic.AddUint64(&c.Changed, delta)
}

func (c *Counter) AddDeleted(delta uint64) {
	atomic.AddUint64(&c.Deleted, delta)
}

func (c *Counter) Flush() Counter {
	return Counter{
		New:     atomic.SwapUint64(&c.New, 0),
		Changed: atomic.SwapUint64(&c.Changed, 0),
		Deleted: atomic.SwapUint64(&c.Deleted, 0),
	}
}
