package ydb

import (
	"context"
	"time"

	"a.yandex-team.ru/kikimr/public/sdk/go/ydb"
	"a.yandex-team.ru/kikimr/public/sdk/go/ydb/table"
	"a.yandex-team.ru/security/libs/go/simplelog"
	"a.yandex-team.ru/security/yadi/snatcher/pkg/feed"
)

func (d *DB) DeleteSrc(ttl int64, srcType string) (deletedVulns []feed.Vulnerability, resultErr error) {
	var res *table.Result
	resultErr = table.Retry(d.ctx, d.sp,
		table.OperationFunc(func(ctx context.Context, s *table.Session) (err error) {
			stmt, err := s.Prepare(ctx, d.updateDeleteActionsQuery)
			if err != nil {
				return err
			}
			_, res, err = stmt.Execute(ctx, rwTX, table.NewQueryParameters(
				table.ValueParam("$ttl", ydb.Int64Value(ttl)),
				table.ValueParam("$timestamp", ydb.Int64Value(time.Now().Unix())),
				table.ValueParam("$srcType", ydb.UTF8Value(srcType)),
			))
			return err
		}),
	)
	if resultErr != nil {
		simplelog.Error("Failed to commit actions")
		return
	}
	for res.NextSet() {
		for res.NextRow() {
			// key, srcType, srcId, lang, pkgName, vulnVersions, cvssScore, title
			vuln := feed.Vulnerability{} // TODO(melkikh): use yadi-web's tableToVuln for this
			res.SeekItem("key")
			res.NextItem()
			vuln.SrcType = res.OUTF8()
			res.NextItem()
			vuln.ID = res.OUTF8()
			res.NextItem()
			vuln.Language = res.OUTF8()
			res.NextItem()
			vuln.Package = res.OUTF8()
			res.NextItem()
			vuln.VulnerableVersions = res.OUTF8()
			res.NextItem()
			vuln.CvssScore = res.OFloat()
			res.NextItem()
			vuln.Title = res.OUTF8()
			deletedVulns = append(deletedVulns, vuln)
		}
	}

	resultErr = res.Err()
	return
}
