package alpine

import (
	"sort"
	"strings"
)

type vulnerability struct {
	ID       string
	Package  string
	CVE      string
	Versions versionsMap
}

type alpineVersion struct {
	Branch string
	Vesion string
	Order  int
}

type versionsMap map[string]string

type alpineVersions []alpineVersion

func (v alpineVersions) Len() int {
	return len(v)
}

func (v alpineVersions) Less(i, j int) bool {
	return v[j].Order < v[i].Order
}

func (v alpineVersions) Swap(i, j int) {
	v[i], v[j] = v[j], v[i]
}

func (v alpineVersions) String() string {
	sort.Sort(v)
	var out strings.Builder
	for _, info := range v {
		out.WriteString(info.Branch)
		out.WriteByte(':')
		out.WriteByte('<')
		out.WriteString(info.Vesion)
		out.WriteByte(' ')
	}

	return strings.TrimSpace(out.String())
}

func (v versionsMap) String() string {
	s := make(alpineVersions, 0)
	for branch, version := range v {
		s = append(s, alpineVersion{
			Branch: branch,
			Vesion: version,
			Order:  branchesOrder[branch],
		})
	}

	return s.String()
}
