package feed

import "context"

const (
	NodeJSPlatform Platform = "nodejs"
	PythonPlatform Platform = "python"
	GolangPlatform Platform = "golang"
	JavaPlatform   Platform = "java"
	UbuntuPlatform Platform = "linux-ubuntu"
	DebianPlatform Platform = "linux-debian"
	AlpinePlatform Platform = "linux-alpine"
	KernelPlatform Platform = "linux-kernel"
)

type (
	Platform = string
	VulnID   = string

	DumpingOpts struct {
		Range      int64
		ReplaceIDs bool
	}

	VulnerabilityFeed interface {
		Name() string
		GetPlatformByAlias(alias string) (Platform, error)
		Dump(ctx context.Context, opts DumpingOpts) (Result, error)
	}

	Result          map[Platform]map[VulnID]Vulnerability
	Vulnerabilities []Vulnerability
)

var Platforms = map[Platform]struct{}{
	NodeJSPlatform: {},
	PythonPlatform: {},
	GolangPlatform: {},
	JavaPlatform:   {},
	UbuntuPlatform: {},
	DebianPlatform: {},
	AlpinePlatform: {},
	KernelPlatform: {},
}

func (v Vulnerabilities) Len() int {
	return len(v)
}

func (v Vulnerabilities) Less(i, j int) bool {
	if v[i].DisclosedAt != v[j].DisclosedAt {
		return v[i].DisclosedAt < v[j].DisclosedAt
	}
	return v[i].YadiID < v[j].YadiID
}

func (v Vulnerabilities) Swap(i, j int) {
	v[i], v[j] = v[j], v[i]
}
