package vulnparser

import (
	"strings"

	"a.yandex-team.ru/security/yadi/snatcher/pkg/feed"
)

var _ Parser = (*JavaParser)(nil)

type JavaParser struct{}

func NewJavaParser() *JavaParser {
	return &JavaParser{}
}

func (p *JavaParser) Parse(yadiVuln *feed.Vulnerability, snykVuln Vulnerability) error {
	if len(snykVuln.VulnerableVersions) > 0 {
		yadiVuln.VulnerableVersions = strings.Join(snykVuln.VulnerableVersions, ", ")
	} else {
		// empty vulnerableVersions -> nothing affects
		yadiVuln.VulnerableVersions = "(, 0)"
	}
	return nil
}
