package vulnparser

import (
	"strings"

	"a.yandex-team.ru/security/yadi/snatcher/pkg/feed"
)

var _ Parser = (*NodeJSParser)(nil)

type NodeJSParser struct{}

func NewNodeJSParser() *NodeJSParser {
	return &NodeJSParser{}
}

func (p *NodeJSParser) Parse(yadiVuln *feed.Vulnerability, snykVuln Vulnerability) error {
	var strictVulnerableVersions []string
	if len(snykVuln.VulnerableVersions) == 0 {
		yadiVuln.VulnerableVersions = processEdgeEffects("")
	} else {
		for _, version := range snykVuln.VulnerableVersions {
			strictVulnerableVersions = append(strictVulnerableVersions, processEdgeEffects(version))
		}
		yadiVuln.VulnerableVersions = strings.Join(strictVulnerableVersions, " || ")
	}
	return nil
}
