package vulnparser

import (
	"a.yandex-team.ru/security/yadi/snatcher/pkg/feed"
)

const (
	snykLangNodeJS = "js"
	snykLangPython = "python"
	snykLangGolang = "golang"
	snykLangJava   = "java"
)

type Parser interface {
	Parse(yadiVuln *feed.Vulnerability, snykVuln Vulnerability) error
}

var parsers = map[string]Parser{
	snykLangNodeJS: NewNodeJSParser(),
	snykLangPython: NewPythonParser(),
	snykLangGolang: NewGolangParser(),
	snykLangJava:   NewJavaParser(),
}

var languages = map[string]string{
	snykLangNodeJS: "nodejs",
	snykLangPython: "python",
	snykLangGolang: "golang",
	snykLangJava:   "java",
}
