package vulnparser

import (
	"strings"

	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/security/yadi/snatcher/pkg/feed"
	"a.yandex-team.ru/security/yadi/snatcher/pkg/unifiedrange"
)

var _ Parser = (*PythonParser)(nil)

type PythonParser struct{}

func NewPythonParser() *PythonParser {
	return &PythonParser{}
}

func (p *PythonParser) Parse(yadiVuln *feed.Vulnerability, snykVuln Vulnerability) error {
	if len(snykVuln.VulnerableVersions) == 0 {
		yadiVuln.VulnerableVersions = processEdgeEffects("")
	} else {
		var versions []string
		for _, versionRanges := range snykVuln.VulnerableVersions {
			if unifiedrange.IsUnifiedRange(versionRanges) {
				version, err := unifiedrange.ToSemverSeries(versionRanges)
				if err != nil {
					return xerrors.Errorf("failed to parse vulnerability %q version: %w", snykVuln.ID, err)
				}
				versions = append(versions, version)
			} else {
				return xerrors.Errorf("version must be unified range: %s", versionRanges)
			}
		}
		yadiVuln.VulnerableVersions = strings.Join(versions, " || ")
	}
	return nil
}
