package ubuntu

import (
	"sort"
	"strings"

	"a.yandex-team.ru/security/yadi/libs/osreleases"
)

type ubuntuVersion struct {
	Release osreleases.Ubuntu
	Vesion  string
}

type ubuntuVersions []ubuntuVersion

func (v ubuntuVersions) Len() int {
	return len(v)
}

func (v ubuntuVersions) Less(i, j int) bool {
	return v[j].Release < v[i].Release
}

func (v ubuntuVersions) Swap(i, j int) {
	v[i], v[j] = v[j], v[i]
}

func (v ubuntuVersions) String() string {
	ignoreUpstream := true
	for _, info := range v {
		if info.Release != osreleases.UbuntuUpstream && info.Vesion == "*" {
			ignoreUpstream = false
			break
		}
	}

	sort.Sort(v)
	var out strings.Builder
	for _, info := range v {
		if info.Release == osreleases.UbuntuUpstream && ignoreUpstream {
			continue
		}

		out.WriteString(info.Release.String())
		out.WriteByte(':')
		out.WriteString(info.Vesion)
		out.WriteByte(' ')
	}

	return strings.TrimSpace(out.String())
}
