package manifestor

import (
	"context"
	"encoding/json"
	"io/ioutil"
)

var _ updator = (*fileManifestor)(nil)

type fileManifestor struct {
	path string
}

func initFile(path string) *fileManifestor {
	return &fileManifestor{path: path}
}

func (h *fileManifestor) update(_ context.Context) (*Manifest, error) {
	var manifest Manifest
	data, err := ioutil.ReadFile(h.path)
	if err != nil {
		return nil, err
	}

	if err = json.Unmarshal(data, &manifest); err != nil {
		return nil, err
	}
	return &manifest, nil
}
