package manifestor

import (
	"context"
	"crypto/tls"
	"fmt"
	"time"

	"github.com/go-resty/resty/v2"

	"a.yandex-team.ru/library/go/certifi"
)

var _ updator = (*httpManifestor)(nil)

type httpManifestor struct {
	path  string
	httpc *resty.Client
}

func initHTTP(path string) *httpManifestor {
	certPool, _ := certifi.NewCertPool()

	httpc := resty.New().
		SetTLSClientConfig(&tls.Config{RootCAs: certPool}).
		SetBaseURL(path).
		SetRetryCount(5).
		SetRetryWaitTime(1 * time.Second).
		SetRetryMaxWaitTime(100 * time.Second).
		AddRetryCondition(func(rsp *resty.Response, err error) bool {
			return err != nil
		})
	return &httpManifestor{path: path, httpc: httpc}
}
func (h *httpManifestor) update(ctx context.Context) (*Manifest, error) {
	var manifest Manifest
	rsp, err := h.httpc.R().
		SetContext(ctx).
		SetResult(&manifest).
		ForceContentType("application/json").
		Get(h.path)
	if err != nil {
		return nil, fmt.Errorf("failed to get manifest file: %w", err)
	}
	if !rsp.IsSuccess() {
		return nil, fmt.Errorf("wrong manifest status code: %s", rsp.Status())
	}
	return &manifest, nil
}
