package manifestor

import (
	"context"
	"strings"
	"sync"
)

const defaultManifestURI = "https://yadi.yandex-team.ru/db/manifest.json"

type (
	updator interface {
		update(ctx context.Context) (*Manifest, error)
	}
	Manifestor struct {
		lock     sync.Mutex
		impl     updator
		Manifest *Manifest
	}
)

func New(path string) *Manifestor {
	if path == "" {
		path = defaultManifestURI
	}

	if strings.HasPrefix(path, "http") {
		return &Manifestor{
			impl:     initHTTP(path),
			Manifest: Empty(),
		}
	}

	return &Manifestor{
		impl:     initFile(path),
		Manifest: Empty(),
	}
}

func (m *Manifestor) Update(ctx context.Context) (*Manifest, error) {
	m.lock.Lock()
	defer m.lock.Unlock()

	manifest, err := m.impl.update(ctx)
	if err != nil {
		return nil, err
	}
	m.Manifest = manifest
	return m.Manifest, m.Manifest.Validate()
}
