package unifiedrange

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

var UnifiedSemverMapping = map[string]string{
	"[2.7.2, 2.7.3)":                ">=2.7.2 <2.7.3",
	"[,1.5.1)":                      "<1.5.1",
	"[,0.26)":                       "<0.26.0",
	"[5.0.0,5.0.6),(0.1beta,1.2.3]": ">=5.0.0 <5.0.6 || >0.1.0 <=1.2.3",
	"[0,]":                          "*",
	"(0,]":                          "*",
	"(,0)":                          "<0.0.0",
	"(,0]":                          "<0.0.0",
	"[2.3.0, 2.3.2)":                ">=2.3.0 <2.3.2",
	"[26.0, 2.6.9)":                 ">=26.0.0 <2.6.9",
	"[,2.15.1)":                     "<2.15.1",
	"[3.0.0,3.0.0b9)":               ">=3.0.0 <3.0.0",
	"[,2017.7.8)":                   "<2017.7.8",
	"[2018.0, 2018.3.3)":            ">=2018.0.0 <2018.3.3",
	"[2015.5.0,2015.5.6)":           ">=2015.5.0 <2015.5.6",
	"[2015.8.0,2015.8.1)":           ">=2015.8.0 <2015.8.1",
	"[,0.8.0-alpha3)":               "<0.8.0",
	"[,1.0.0b1)":                    "<1.0.0",
	"[,1.3.2)":                      "<1.3.2",
	"[2.0.0.alpha1,2.0.0b2) ":       ">=2.0.0 <2.0.0",
	"[,2.1.0beta2)":                 "<2.1.0",
	"[,8.0.0.0b2)":                  "<8.0.0",
	"[,0.2dev-20150922)":            "<0.2.0",
	"[,0.99999999)":                 "<0.99999999.0",
	"[1.0b1,1.0b9)":                 ">=1.0.0 <1.0.0",
	"[0.4.1-a]":                     "==0.4.1",
	"[0.4a]":                        "==0.4.0",
	"[0.41alpha]":                   "==0.41.0",
	"[0.4]":                         "==0.4.0",
	"[1.2-alpha2,1.6.5)":            ">=1.2.0 <1.6.5",
	"[0.4,]":                        ">=0.4.0",
	"[,1.4.11), [1.5,1.5.6), [1.6,1.6.3), [1.7,1.7b2)": "<1.4.11 || >=1.5.0 <1.5.6 || >=1.6.0 <1.6.3 || >=1.7.0 <1.7.0",
}

func TestSimple(t *testing.T) {

	for unified, semver := range UnifiedSemverMapping {
		testResult, err := ToSemverSeries(unified)
		if !assert.NoError(t, err) {
			return
		}
		assert.Equal(t, semver, testResult)
	}

}
