package config

import (
	"net/url"
	"path"

	"a.yandex-team.ru/security/libs/go/yacsrf"
	"a.yandex-team.ru/security/yadi/web/internal/db"
	"a.yandex-team.ru/security/yadi/web/internal/vulndb"
)

const (
	webDatabaseSuffix = "web.json"
	defaultYadiDBPath = "https://s3.mds.yandex.net/yadi/"
)

type (
	Config struct {
		WebURL          string
		YdbDatabase     string
		YdbPath         string
		YdbEndpoint     string
		WatcherCronSpec string
		CsrfKey         string
		AdminUsers      []string
		AdminGroups     []string
		HTTPPort        uint32
		Debug           bool
		VulnDBPath      url.URL
		ManifestPath    url.URL
	}
)

func (c *Config) DBConfig() db.Options {
	return db.Options{
		Endpoint: c.YdbEndpoint,
		Database: c.YdbDatabase,
		Path:     c.YdbPath,
	}
}

func (c *Config) VulnDBConfig() vulndb.Options {
	webDatabaseURL := c.VulnDBPath
	webDatabaseURL.Path = path.Join(webDatabaseURL.Path, webDatabaseSuffix)
	return vulndb.Options{
		DatabaseURL: webDatabaseURL.String(),
	}
}

func (c *Config) YaCsrfConfig() yacsrf.Options {
	return yacsrf.Options{
		SecretKey: c.CsrfKey,
		TTL:       yacsrf.TokenTTL,
	}
}
