package common

import (
	"errors"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/security/yadi/web/internal/echoutils"
	"a.yandex-team.ru/security/yadi/web/internal/infra"
	"a.yandex-team.ru/security/yadi/web/internal/validators"
)

type Controller struct {
	*infra.Infra
}

func (c *Controller) BuildRoute(g *echo.Group) error {
	g.GET("/abc", c.abc)
	g.GET("/project", c.project)
	g.GET("/project/activate", c.activeProject)
	g.GET("/owners", c.owners)
	return nil
}

func (c *Controller) abc(e echo.Context) error {
	abcID := e.QueryParam("slug")
	if abcID == "" {
		return echoutils.APIError(e, errors.New("please provide ABC service"))
	}

	// TODO(buglloc): real validate? It's disabled in old server
	return echoutils.APIOk(e, nil)
}

func (c *Controller) owners(e echo.Context) error {
	owners := e.QueryParam("owners")
	if owners == "" {
		return echoutils.APIError(e, errors.New("please provide owners"))
	}

	// TODO(buglloc): real validate? It's disabled in old server
	return echoutils.APIOk(e, nil)
}

func (c *Controller) project(e echo.Context) error {
	service := e.QueryParam("service")
	name := e.QueryParam("name")
	if service == "" || name == "" {
		return echoutils.APIError(e, errors.New("please provide abc service and project name"))
	}

	err := validators.ProjectUniq(c.Infra, service, name)
	if err != nil {
		return echoutils.APIError(e, err)
	}
	return echoutils.APIOk(e, nil)
}

func (c *Controller) activeProject(e echo.Context) error {
	service := e.QueryParam("service")
	name := e.QueryParam("name")
	if service == "" || name == "" {
		return echoutils.APIError(e, errors.New("please provide abc service and project name"))
	}

	err := validators.ProjectActive(c.Infra, service, name)
	return echoutils.APIOk(e, err == nil)
}
