package moderatepage

import (
	"net/http"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/security/yadi/web/internal/infra"
)

type Controller struct {
	*infra.Infra
}

func (c *Controller) BuildRoute(g *echo.Group) error {

	g.GET("", func(c echo.Context) error {
		return c.Redirect(http.StatusFound, "/moderate/new")
	})

	g.GET("/new", c.list)
	g.GET("/changed", c.list)
	g.GET("/feed", c.list)

	return nil
}

func (c *Controller) list(e echo.Context) error {
	return e.Render(http.StatusOK, "moderate-list.html", echo.Map{
		"advisoryTypes": c.VulnDB.AdvisoryTypes(),
	})
}
