package moderator

import (
	"net/url"
	"strconv"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/security/yadi/snatcher/pkg/feed"
	"a.yandex-team.ru/security/yadi/web/internal/models"
)

type (
	response struct {
		NextPageURL string `json:"next_page"`
		IsLast      bool   `json:"is_last"`
	}

	listNewResponse struct {
		response
		Vulns []models.VulnWithAction `json:"vulns"`
	}

	listChangedResponse struct {
		response
		Vulns []models.VulnsPair `json:"vulns"`
	}

	listAllResponse struct {
		response
		Vulns []feed.Vulnerability `json:"vulns"`
	}
)

func newListAllResponse(ctx echo.Context, f models.FeedLookupQuery) (response listAllResponse, err error) {
	response.IsLast = f.IsLast
	response.NextPageURL, err = nextPageURL(ctx, f)
	if err != nil {
		return
	}
	response.Vulns = f.AllVulns
	return
}

func newListNewResponse(ctx echo.Context, f models.FeedLookupQuery) (response listNewResponse, err error) {
	response.IsLast = f.IsLast
	response.NextPageURL, err = nextPageURL(ctx, f)
	if err != nil {
		return
	}
	response.Vulns = f.VulnsWithActions
	return
}

func newListChangedResponse(ctx echo.Context, f models.FeedLookupQuery) (response listChangedResponse, err error) {
	response.IsLast = f.IsLast
	response.NextPageURL, err = nextPageURL(ctx, f)
	if err != nil {
		return
	}
	response.Vulns = f.VulnsPairs
	return
}

func nextPageURL(ctx echo.Context, f models.FeedLookupQuery) (string, error) {
	if !f.IsLast {
		u, err := url.Parse(ctx.Request().RequestURI)
		if err != nil {
			return "", err
		}
		u.Scheme = ctx.Scheme()
		u.Host = ctx.Request().Host
		q := u.Query()
		q.Set("gt", strconv.FormatUint(f.LastKey, 10))
		u.RawQuery = q.Encode()
		return u.String(), nil
	}
	return "", nil
}
