package proxy

import (
	"fmt"
	"net/http"
	"net/http/httputil"
	"strings"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/security/yadi/web/internal/echoutils"
	"a.yandex-team.ru/security/yadi/web/internal/infra"
)

type Controller struct {
	*infra.Infra
	downloadProxy *httputil.ReverseProxy
}

func (c *Controller) BuildRoute(g *echo.Group) error {
	c.initDownloadProxy()
	g.GET("/:filename", c.proxy)
	return nil
}

func (c *Controller) proxy(e echo.Context) error {
	filename := e.Param("filename")
	if strings.Contains(filename, "/") {
		return echoutils.APIError(e, fmt.Errorf("invalid filename: %s", filename))
	}

	reqURL := c.CFG.VulnDBPath
	reqURL.Path = filename

	req, err := http.NewRequestWithContext(e.Request().Context(), "GET", reqURL.String(), nil)
	if err != nil {
		return fmt.Errorf("failed to create proxy request: %w", err)
	}

	c.downloadProxy.ServeHTTP(e.Response(), req)
	return nil
}

func (c *Controller) initDownloadProxy() {
	director := func(req *http.Request) {
		req.URL.Scheme = "https"
		req.URL.Host = c.CFG.VulnDBPath.Host
	}

	c.downloadProxy = &httputil.ReverseProxy{
		Director: director,
	}
}
