package releases

import (
	"fmt"
	"net/http"
	"net/http/httputil"
	"net/url"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/security/yadi/web/internal/infra"
)

const (
	secToolsBase = "http://tools.sec.yandex-team.ru/api/v1/release/yadi/"
)

type Controller struct {
	*infra.Infra
}

func (c *Controller) BuildRoute(g *echo.Group) error {
	g.GET("/:system/:version", c.handler)
	g.GET("/:system/:version/:handler", c.handler)
	return nil
}

func (c *Controller) handler(e echo.Context) error {
	uri := secToolsBase + fmt.Sprintf(
		"/%s/%s",
		url.PathEscape(e.Param("system")),
		url.PathEscape(e.Param("version")),
	)

	if handler := e.Param("handler"); handler != "" {
		uri += "/" + url.PathEscape(handler)
	}

	target, err := url.Parse(uri)
	if err != nil {
		return err
	}

	p := httputil.ReverseProxy{
		Director: func(req *http.Request) {
			req.URL = target
			req.Host = target.Host
		},
	}
	p.ServeHTTP(e.Response(), e.Request())
	return nil
}
