package queries

import (
	"fmt"
)

func SelectProjectQuery(pathPrefix string) string {
	return fmt.Sprintf(`
PRAGMA TablePathPrefix("%s");
DECLARE $service AS Utf8;
DECLARE $name AS Utf8;

SELECT
    active, owners, repo_uri, severity, skips, targets
FROM
    projects
WHERE
	id = Digest::CityHash($service||$name) AND service = $service AND name = $name
LIMIT 1
;`, pathPrefix)
}

func SelectProjectDependenciesQuery(pathPrefix string) string {
	return fmt.Sprintf(`
PRAGMA TablePathPrefix("%s");
DECLARE $service AS Utf8;
DECLARE $name AS Utf8;

SELECT
    dependencies
FROM
    projects
WHERE
	id = Digest::CityHash($service||$name) AND service = $service AND name = $name
LIMIT 1
;`, pathPrefix)
}

func CreateProjectQuery(pathPrefix string) string {
	return fmt.Sprintf(`
PRAGMA TablePathPrefix("%s");
DECLARE $service AS Utf8;
DECLARE $name AS Utf8;
DECLARE $active AS Bool;
DECLARE $owners AS Utf8;
DECLARE $repoUri AS Utf8;
DECLARE $severity AS Float;
DECLARE $targets AS Json;
DECLARE $createdBy AS Int64;
DECLARE $createdAt AS Int64;

INSERT INTO projects
    (id, service, name, active, owners, repo_uri, severity, targets, created_at, updated_at)
VALUES
    (Digest::CityHash($service||$name), $service, $name, $active, $owners, $repoUri, $severity, $targets, $createdAt, $createdAt)
;`, pathPrefix)
}

func ActivateProjectQuery(pathPrefix string) string {
	return fmt.Sprintf(`
PRAGMA TablePathPrefix("%s");
DECLARE $service AS Utf8;
DECLARE $name AS Utf8;
DECLARE $createdBy AS Uint64;
DECLARE $updatedAt AS Int64;

UPSERT INTO projects
    (id, service, name, active, created_by, updated_at)
VALUES
    (Digest::CityHash($service||$name), $service, $name, true, $createdBy, $updatedAt)
;`, pathPrefix)
}
