package queries

import "fmt"

func SelectPyPkgVersionQuery(pathPrefix string) string {
	return fmt.Sprintf(`
PRAGMA TablePathPrefix("%s");
DECLARE $name AS Utf8;
DECLARE $version AS Utf8;

SELECT
    license, pkg_url, requirements, updated_at
FROM
    package_versions
WHERE
	key = Digest::CityHash($name) AND name = $name AND version = $version
LIMIT 1
;`, pathPrefix)
}

func ListPyPkgsQuery(pathPrefix string) string {
	return fmt.Sprintf(`
PRAGMA TablePathPrefix("%s");

DECLARE $lastName AS Utf8;
DECLARE $lastKey AS Uint64;
DECLARE $limit AS Uint64;

$data = (
    SELECT * FROM packages
    WHERE name = $lastName AND key > $lastKey
    ORDER BY key, name LIMIT $limit

    UNION ALL

    SELECT * FROM packages
    WHERE key > $lastKey
    ORDER BY key, name LIMIT $limit
);

SELECT
    key, name, pkg_name, source, versions, updated_at
FROM
    $data
ORDER BY key, name
LIMIT $limit
;`, pathPrefix)
}

func SelectPyPkgQuery(pathPrefix string) string {
	return fmt.Sprintf(`
PRAGMA TablePathPrefix("%s");
DECLARE $name AS Utf8;

SELECT
    pkg_name, source, versions, updated_at
FROM
    packages
WHERE
	key = Digest::CityHash($name) AND name = $name
LIMIT 1
;`, pathPrefix)
}
