package models

import (
	"a.yandex-team.ru/security/yadi/snatcher/pkg/feed"
)

type (
	VulnWithAction struct {
		Vuln   feed.Vulnerability `json:"vuln"`
		Action string             `json:"action"`
	}

	FeedLookupQuery struct {
		IsLast           bool
		LastKey          uint64
		VulnsWithActions []VulnWithAction
		VulnsPairs       []VulnsPair
		AllVulns         []feed.Vulnerability
	}

	VulnsPair struct {
		Old    feed.Vulnerability `json:"old"`
		New    feed.Vulnerability `json:"new"`
		Action string             `json:"action"`
	}
)
