package models

import "time"

type Project struct {
	Service      string       `json:"service"`
	Name         string       `json:"name"`
	Owners       string       `json:"owners"`
	RepoURI      string       `json:"repo_uri"`
	Skips        []string     `json:"skips"`
	Targets      []string     `json:"targets"`
	Dependencies Dependencies `json:"dependencies"`
	CreatedBy    uint64       `json:"created_by"`
	CreatedAt    time.Time    `json:"created_at"`
	UpdatedAt    time.Time    `json:"updated_at"`
	Severity     float32      `json:"severity"`
	Active       bool         `json:"active"`
}

type Dependencies []Dependency

type SyncInfo struct {
	Service      string       `json:"service"`
	Name         string       `json:"name"`
	Targets      []string     `json:"targets,omitempty"`
	Skips        []string     `json:"skips,omitempty"`
	Severity     *float32     `json:"severity,omitempty"`
	Dependencies Dependencies `json:"dependencies,omitempty"`
}

type Dependency struct {
	Path        string     `json:"path"`
	Language    string     `json:"language"`
	MainPackage ModuleTree `json:"package"`
}

type ModuleTree struct {
	PackageName  string       `json:"package_name"`
	Version      string       `json:"version"`
	From         string       `json:"from"`
	Dependencies []ModuleTree `json:"dependencies"`
}
