package server

import (
	"a.yandex-team.ru/security/yadi/web/internal/controllers"
	"a.yandex-team.ru/security/yadi/web/internal/controllers/common"
	"a.yandex-team.ru/security/yadi/web/internal/controllers/confirmator"
	"a.yandex-team.ru/security/yadi/web/internal/controllers/moderatepage"
	"a.yandex-team.ru/security/yadi/web/internal/controllers/moderator"
	"a.yandex-team.ru/security/yadi/web/internal/controllers/project"
	"a.yandex-team.ru/security/yadi/web/internal/controllers/proxy"
	"a.yandex-team.ru/security/yadi/web/internal/controllers/python"
	"a.yandex-team.ru/security/yadi/web/internal/controllers/releases"
	"a.yandex-team.ru/security/yadi/web/internal/controllers/vulndb"
	"a.yandex-team.ru/security/yadi/web/internal/infra"
)

type serverControllers struct {
	Common       controllers.Controller
	Python       controllers.Controller
	Releases     controllers.Controller
	Vulndb       controllers.Controller
	Project      controllers.Controller
	Confirmator  controllers.Controller
	Moderator    controllers.Controller
	ModeratePage controllers.Controller
	Proxy        controllers.Controller
}

func newControllers(infra *infra.Infra) serverControllers {
	return serverControllers{
		Common:       &common.Controller{Infra: infra},
		Python:       &python.Controller{Infra: infra},
		Releases:     &releases.Controller{Infra: infra},
		Vulndb:       &vulndb.Controller{Infra: infra},
		Project:      &project.Controller{Infra: infra},
		Confirmator:  &confirmator.Controller{Infra: infra},
		Moderator:    &moderator.Controller{Infra: infra},
		ModeratePage: &moderatepage.Controller{Infra: infra},
		Proxy:        &proxy.Controller{Infra: infra},
	}
}
