package validators

import (
	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/security/yadi/web/internal/db"
	"a.yandex-team.ru/security/yadi/web/internal/infra"
)

func Owners(owners string) error {
	// TODO
	return nil
}

func Severity(severity float32) error {
	if severity <= 0 {
		return xerrors.Errorf("severity %f less then 0", severity)
	}
	return nil
}

func ProjectExists(infra *infra.Infra, service, name string) error {
	_, err := infra.DB.LookupProjectInfo(service, name)
	if err != nil {
		if err == db.ErrNotFound {
			return xerrors.Errorf("project %s/%s not found", service, name)
		}
		return err
	}
	return nil
}

func ProjectUniq(infra *infra.Infra, service, name string) error {
	_, err := infra.DB.LookupProjectInfo(service, name)
	if err != nil {
		if err == db.ErrNotFound {
			return nil
		}
		return err
	}

	return xerrors.Errorf("project %s/%s already exists", service, name)
}

func ProjectActive(infra *infra.Infra, service, name string) error {
	project, err := infra.DB.LookupProjectInfo(service, name)
	if err != nil && err != db.ErrNotFound {
		return xerrors.Errorf("failed to check active project %s/%s: %w", service, name, err)
	}

	if project == nil || !project.Active {
		return xerrors.Errorf("project %s/%s not activated yet", service, name)
	}
	return nil
}
