package advisories

type ExternalReferences struct {
	Title string
	URL   string
}

type Advisory struct {
	ID                 string               `json:"id"`
	Title              string               `json:"title"`
	ModuleName         string               `json:"module_name"`
	ModuleURL          string               `json:"url"`
	Desc               string               `json:"description"`
	Type               string               `json:"type"`
	Lang               string               `json:"language"`
	Severity           string               `json:"severity"`
	RichDescription    bool                 `json:"rich_description"`
	CVSSScore          float32              `json:"cvss_score"`
	VulnerableVersions string               `json:"vulnerable_versions"`
	DisclosedAt        string               `json:"-"`
	DisclosedAtUnix    int64                `json:"disclosed"`
	ExternalReferences []ExternalReferences `json:"external_references"`
}
