package main

import (
	"fmt"
	"os"

	"a.yandex-team.ru/library/go/maxprocs"
	"a.yandex-team.ru/security/yadi/yadi-arc/internal/commands"
)

func fatal(err error) {
	_, _ = fmt.Fprintf(os.Stderr, "yadi-arc: %v\n", err)
	os.Exit(1)
}

func main() {
	maxprocs.AdjustAuto()

	if err := commands.Execute(); err != nil {
		fatal(err)
	}
}
