package commands

import (
	"fmt"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/security/yadi/yadi-arc/pkg/manager/cpp"
)

var cppContribCmd = &cobra.Command{
	Use:   "cpp [flags]",
	Short: "Test C++ contribs for any known vulnerabilities",
	RunE: func(_ *cobra.Command, _ []string) error {
		targets, err := cpp.FindTargets(rootOpts.ArcadiaRoot)
		if err != nil {
			return err
		}

		if len(targets) == 0 {
			return fmt.Errorf("no targets in path: %s", rootOpts.ArcadiaRoot)
		}

		pm, err := cpp.NewManager(targets, cpp.ManagerOpts{
			ArcadiaPath: rootOpts.ArcadiaRoot,
		})

		if err != nil {
			return err
		}

		if rootOpts.ListOnly {
			return doList(pm)
		}
		return doAnalyzeContib(pm)
	},
	Hidden: true,
}
