package commands

import (
	"fmt"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/security/libs/go/simplelog"
	"a.yandex-team.ru/security/yadi/yadi-arc/pkg/manager/java"
)

var fixOpts = struct {
	ExcludesFile string
	CreateIssues bool
}{
	ExcludesFile: "",
}

var fixPolicyCmd = &cobra.Command{
	Use:   "fix [flags]",
	Short: "fix denial policy with excludes",
	RunE: func(_ *cobra.Command, args []string) error {

		excludes, err := readFixExcludes(fixOpts.ExcludesFile)
		if err != nil {
			return err
		}

		targets, err := java.FindTargets(rootOpts.ArcadiaRoot)
		if err != nil {
			return err
		}

		if len(targets) == 0 {
			return fmt.Errorf("no targets in path: %s", rootOpts.ArcadiaRoot)
		}
		simplelog.Info(fmt.Sprintf("found %d targets", len(targets)))

		pm, err := java.NewManager(targets, java.ManagerOpts{
			ArcadiaPath: rootOpts.ArcadiaRoot,
		})
		if err != nil {
			return err
		}

		return doFixPolicy(pm, excludes)
	},
}

func init() {
	flags := fixPolicyCmd.PersistentFlags()
	flags.StringVar(&fixOpts.ExcludesFile, "excludes", fixOpts.ExcludesFile, "file with excludes (usually affected-targets.json from AFFECTED_TARGETS resource")
	flags.BoolVar(&fixOpts.CreateIssues, "with-issues", fixOpts.CreateIssues, "create issues in ")
}
