package commands

import (
	"fmt"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/security/yadi/yadi-arc/pkg/manager/golang"
)

var goOpts struct {
	withTests bool
}

var goContribCmd = &cobra.Command{
	Use:   "golang [flags]",
	Short: "Test Golang contribs for any known vulnerabilities",
	RunE: func(_ *cobra.Command, _ []string) error {
		targets, err := golang.FindTargets(rootOpts.ArcadiaRoot)
		if err != nil {
			return err
		}

		if len(targets) == 0 {
			return fmt.Errorf("no targets in path: %s", rootOpts.ArcadiaRoot)
		}

		pm, err := golang.NewManager(targets, golang.ManagerOpts{
			ArcadiaPath: rootOpts.ArcadiaRoot,
			WithTests:   goOpts.withTests,
		})

		if err != nil {
			return err
		}

		if rootOpts.ListOnly {
			return doList(pm)
		}
		return doAnalyzeContib(pm)
	},
}

func init() {
	flags := goContribCmd.PersistentFlags()
	flags.BoolVar(&goOpts.withTests, "with-tests", false,
		"check pkgs required for tests")
}
