package commands

import (
	"fmt"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/security/libs/go/simplelog"
	"a.yandex-team.ru/security/yadi/yadi-arc/pkg/manager/java"
)

var generateJavaPolicyCmd = &cobra.Command{
	Use:   "java [flags]",
	Short: "generate denial policy for vulnerable Java contribs",
	RunE: func(_ *cobra.Command, args []string) error {
		targets, err := java.FindTargets(rootOpts.ArcadiaRoot)
		if err != nil {
			return err
		}

		if len(targets) == 0 {
			return fmt.Errorf("no targets in path: %s", rootOpts.ArcadiaRoot)
		}
		simplelog.Info(fmt.Sprintf("found %d targets", len(targets)))

		pm, err := java.NewManager(targets, java.ManagerOpts{
			ArcadiaPath: rootOpts.ArcadiaRoot,
		})
		if err != nil {
			return err
		}

		return doGeneratePolicy(pm)
	},
}
