package commands

import (
	"fmt"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/security/yadi/yadi-arc/pkg/manager/java"
)

var javaContribCmd = &cobra.Command{
	Use:   "java [flags]",
	Short: "Test Java contribs for any known vulnerabilities",
	RunE: func(_ *cobra.Command, _ []string) error {
		targets, err := java.FindTargets(rootOpts.ArcadiaRoot)
		if err != nil {
			return err
		}

		if len(targets) == 0 {
			return fmt.Errorf("no targets in path: %s", rootOpts.ArcadiaRoot)
		}

		pm, err := java.NewManager(targets, java.ManagerOpts{
			ArcadiaPath: rootOpts.ArcadiaRoot,
		})
		if err != nil {
			return err
		}

		if rootOpts.ListOnly {
			return doList(pm)
		}
		return doAnalyzeContib(pm)
	},
}
