package commands

import (
	"fmt"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/security/yadi/yadi-arc/pkg/manager/python"
)

var pyContribCmd = &cobra.Command{
	Use:   "python [flags]",
	Short: "Test Python contribs for any known vulnerabilities",
	RunE: func(_ *cobra.Command, _ []string) error {
		targets, err := python.FindTargets(rootOpts.ArcadiaRoot)
		if err != nil {
			return err
		}

		if len(targets) == 0 {
			return fmt.Errorf("no targets in path: %s", rootOpts.ArcadiaRoot)
		}

		pm, err := python.NewManager(targets, python.ManagerOpts{})
		if err != nil {
			return err
		}

		if rootOpts.ListOnly {
			return doList(pm)
		}
		return doAnalyzeContib(pm)
	},
}
