package config

import (
	"a.yandex-team.ru/library/go/core/buildinfo"
)

const (
	Version = "0.4"
)

var (
	// FeedURI - feed url
	// where {lang} - Language to analyze, currently supported nodejs and python
	FeedURI = "https://yadi.yandex-team.ru/db/{lang}.json.gz"

	SkipIssues      []string
	OnlyIssues      []string
	MinimumSeverity float32
)

func FullVersion() string {
	if buildinfo.Info.ArcadiaSourceRevision != "" {
		return Version + "." + buildinfo.Info.ArcadiaSourceRevision
	}
	return Version
}
