package consolefmt

import (
	"bytes"
	"strings"
	"text/template"

	"a.yandex-team.ru/security/libs/go/simplelog"
	"a.yandex-team.ru/security/yadi/yadi-arc/internal/formatter/textfmt"
	"a.yandex-team.ru/security/yadi/yadi-arc/pkg/analyze"
)

const tmpl = `
{{- $cdefault := "\033[0m" -}}
{{$ctitle := "\033[95m" -}}
{{$chightlight := "\033[1m" -}}
{{range $i, $module := . }}
{{ $ctitle }}[{{ $i }}] {{ $module.Path }}{{ $cdefault }}{{if $module.Owners}} (owners: {{ join $module.Owners ","}}){{end}}:
{{range $_, $issue := $module.Issues}}
  {{ severityColor $issue.Severity }}{{ $issue.Severity }} severity vulnerability found on {{ $issue.String }}{{ $cdefault }}:
  - desc: {{ $issue.Summary }}
  - id: {{ $issue.ID }}
  - info: {{ $issue.Reference }}
{{- if $issue.LocalPath}}
  - path: {{ $issue.LocalPath }}
{{- end}}
  - vulnerable versions: {{ $issue.RawVersions }}
{{- if $issue.VulnPaths }}
  - vulnerable paths: {{ $issue.VulnPaths }}
  - vulnerable path samples:
{{- range $_, $paths := $issue.VulnPathSamples }}
    * {{join $paths " > " }}
{{- end -}}
{{ end }}
{{ end }}
{{- end -}}
`

var templateFns = template.FuncMap{
	"severityColor": severityToConsoleColor,
	"join":          strings.Join,
}

func IssuesFormatter(results analyze.ResultAnalyze) string {
	t := template.Must(template.New("console_result").Funcs(templateFns).Parse(tmpl))
	var result bytes.Buffer

	err := t.Execute(&result, results)
	if err != nil {
		simplelog.Error("failed to render results", "err", err)
	}

	return result.String()
}

var ListFormatter = textfmt.ListFormatter

func severityToConsoleColor(severity string) string {
	switch severity {
	case "Low":
		return "\033[94m"
	case "Medium":
		return "\033[93m"
	case "High":
		return "\033[91m"
	case "Critical":
		return "\033[31;1m"
	default:
		// info level
		return "\033[0m"
	}
}
