package policyfmt

import (
	"fmt"
	"os"
	"sort"
	"strings"
	"time"

	"a.yandex-team.ru/security/yadi/libs/policy"
	"a.yandex-team.ru/security/yadi/yadi-arc/internal/formatter"
	"a.yandex-team.ru/security/yadi/yadi-arc/pkg/analyze"
)

type Excludes map[string]struct{}

func header() string {
	result := "# This is build policy was generated by yadi-arc"
	now := time.Now().String()
	hostname, err := os.Hostname()
	if err != nil {
		hostname = "unknown"
	}
	result += fmt.Sprintf(" at %s on %s host\n\n", now, hostname)
	return result
}

func PolicyFormatterWithExcludes() formatter.AnalyzeFn {
	return func(results analyze.ResultAnalyze) string {
		result := strings.Builder{}
		result.WriteString(header())

		// sorting result by contrib
		sort.Slice(results, func(i, j int) bool { return results[i].Path < results[j].Path })
		for _, module := range results {
			sort.SliceStable(module.Issues, func(i, j int) bool { return module.Issues[i].CVSSScore < module.Issues[j].CVSSScore })
			contribPolicy := policy.NewPolicy(module.Path)
			contribPolicy.Comment(fmt.Sprintf("vulnerabilities: %s", mergeVulns(module.Issues, ", ")))

			for _, consumer := range module.Consumers {
				contribPolicy.Allow(consumer)
			}

			contribPolicy.DenyAll()
			result.WriteString(contribPolicy.String())
		}
		return result.String()
	}
}

func mergeVulns(list analyze.IssueList, sep string) string {
	vulns := make([]string, len(list))
	for i := range list {
		vulns[i] = list[i].Vulnerability.ID
	}
	sort.SliceStable(vulns, func(i, j int) bool {
		return vulns[i] < vulns[j]
	})
	return strings.Join(vulns, sep)
}

func ListFormatter(_ analyze.ResultList) string {
	panic("not supported")
}
