package analyze

import "a.yandex-team.ru/security/yadi/yadi/pkg/feed"

type Option func(*Analyzer)

// WithFeedOptions allows to configure vulnFeed
func WithFeedOptions(opts feed.Options) Option {
	return func(a *Analyzer) {
		a.feedFetcher = feed.New(opts)
	}
}

// WithExpandOwners enables or disables owner groups
func WithExpandOwners(expand bool) Option {
	return func(a *Analyzer) {
		a.resolveGroups = expand
	}
}

// WithCollectorProvider allows use issue collector to customize merge/split logic
func WithCollectorProvider(p CollectorProvider) Option {
	return func(a *Analyzer) {
		a.issueCollector = p
	}
}

// WithVulnerabilityExcludes setups list of excluded vulnerabilities
func WithVulnerabilityExcludes(excludes []string) Option {
	return func(a *Analyzer) {
		a.excludedVulns = make(map[string]struct{}, len(excludes))

		for _, id := range excludes {
			a.excludedVulns[id] = struct{}{}
		}
	}
}

// WithVulnerabilityWhitelist setups list of excluded vulnerabilities
func WithVulnerabilityWhitelist(whitelist []string) Option {
	return func(a *Analyzer) {
		a.vulnsWhitelist = make(map[string]struct{}, len(whitelist))

		for _, id := range whitelist {
			a.vulnsWhitelist[id] = struct{}{}
		}
	}
}
