package analyze

import (
	"fmt"

	"a.yandex-team.ru/security/yadi/libs/cvs"
	"a.yandex-team.ru/security/yadi/yadi-arc/pkg/manager"
	"a.yandex-team.ru/security/yadi/yadi/pkg/feed"
)

type (
	CollectorProvider func() Collector

	Collector interface {
		Collect(vuln feed.Vulnerability, module manager.Module, path []manager.Module)
		Results() []VulnerableModule
	}

	ResultAnalyze []VulnerableModule

	ResultList []manager.Module

	Issue struct {
		feed.Vulnerability
		LocalPath       string     `json:"local_path"`
		Version         string     `json:"version"`
		VulnPaths       int        `json:"vulnerable_paths,omitempty"`
		VulnPathSamples [][]string `json:"vulnerable_paths_samples,omitempty"`
	}

	VulnerableModule struct {
		Path      string       `json:"path"`
		Owners    []string     `json:"owners"`
		Version   string       `json:"version"`
		Issues    IssueList    `json:"issues"`
		Consumers ConsumerList `json:"consumers,omitempty"`
	}

	IssueList []Issue

	ConsumerList []string
)

func (slice IssueList) Len() int {
	return len(slice)
}

func (slice IssueList) Less(i, j int) bool {
	return slice[i].CVSSScore > slice[j].CVSSScore
}

func (slice IssueList) Swap(i, j int) {
	slice[i], slice[j] = slice[j], slice[i]
}

func (y *Issue) Severity() string {
	return cvs.ToSeverity(y.CVSSScore)
}

func (y *Issue) String() string {
	return fmt.Sprintf("%s@%s", y.PackageName, y.Version)
}
