package analyze

import (
	"context"

	"a.yandex-team.ru/security/yadi/yadi-arc/pkg/manager"
	"a.yandex-team.ru/security/yadi/yadi/pkg/feed"
)

type modulesWalker struct {
	rootModule     manager.Module
	vulnFeed       feed.Vulnerabilities
	excludedVulns  map[string]struct{}
	vulnsWhitelist map[string]struct{}
	visitedModules map[string]struct{}
	collector      Collector
}

func (w *modulesWalker) Walk(ctx context.Context) error {
	return w.walk(ctx, w.rootModule, nil)
}

func (w *modulesWalker) walk(ctx context.Context, module manager.Module, parents []manager.Module) error {
	select {
	case <-ctx.Done():
		return ErrCanceled
	default:
	}

	if _, ok := w.visitedModules[module.Name]; ok {
		// don't check module same time
		return nil
	}

	w.visitedModules[module.Name] = struct{}{}
	for _, vuln := range w.vulnFeed.ForPackage(module.Name) {
		if _, skip := w.excludedVulns[vuln.ID]; skip {
			continue
		}

		if _, whitelisted := w.vulnsWhitelist[vuln.ID]; !whitelisted && len(w.vulnsWhitelist) > 0 {
			continue
		}

		if !vuln.CheckVersion(module.Version) {
			continue
		}

		w.collector.Collect(vuln, module, append(parents, module))
	}

	if len(module.Dependencies) == 0 {
		return nil
	}

	newParents := append(parents, module)
	for _, dep := range module.Dependencies {
		err := w.walk(ctx, dep, newParents)
		if err != nil {
			return err
		}
	}

	return nil
}
