package manager

// Интерфейс менеджера модулей, с которым работает анализатор.
// С т.з. анализатора, менеджер - итератор top-level модулей (то как менеджер это делает не его забота).
//
// Типичный flow работы с менеджером:
//  for pm.NextModule() {
//  	module := pm.Module()
//  	doSmthWithModule(module)
//  }
//
//  if err := pm.Err(); err != nil {
//  	panic("failed to iterate over modules")
//  }
//
type Manager interface {
	// Name возвращает имя менеджера
	Name() string

	// NextModule должен вернуть true если мы обошли еще не все модули
	NextModule() bool

	// Module возвращает текущий top-level модуль
	Module() Module

	// Err возвращает последнюю ошибку
	Err() error
}
