package manager

import (
	"fmt"
	"strings"

	"a.yandex-team.ru/security/yadi/libs/versionarium"
)

type Module struct {
	// Имя модуля, используется для поиска уязвимостей в фиде, вывода и т.д.
	Name string `json:"name"`
	// Язык, используется для получения правильного фида
	// Находится в модуле, т.к. некоторые менеджеры (e.g. yamake) могут возвращать top-level модули для разных языков
	Language string `json:"language"`
	// Путь к модулю в Аркадии (обычно его папочка)
	LocalPath string `json:"path"`
	// Версия модуля, используется для вывода и матчинга "vulnerable_versions" уязвимости
	Version versionarium.Version `json:"version"`
	// Список оунеров модуля. Обычно парсится из ya.make, Аркадийные группы анализатор разворачивает сам
	Owners []string `json:"-"`
	// Список зависимостей модуля. В большинстве случаев пуст
	Dependencies []Module `json:"dependencies"`
	fullName     string
}

func (m *Module) String() string {
	if m.fullName != "" {
		return m.fullName
	}

	if m.Version != nil {
		m.fullName = fmt.Sprintf("%s@%s", m.Name, m.Version.String())
	} else {
		m.fullName = m.Name
	}

	return m.fullName
}

func BuildPath(modules []Module) []string {
	out := make([]string, len(modules))
	for i := len(modules) - 1; i >= 0; i-- {
		out[i] = modules[i].Name
	}
	return out
}

func BuildTextPath(modules []Module) string {
	return strings.Join(BuildPath(modules), " > ")
}
